#include "digirule2.h"

bool_t t1ms;

void main( void )
{
	OSCCONbits.IRCF = 0b110;	// Fosc to 8 MHz
	
	// initialize ports
	ANSEL	= 0b00000000;		// all analog-capable pins to digital
	ANSELH	= 0b00000000;
	
	LATA	= 0b00000000;
	TRISA	= 0b00000000;		// RA7..0 (DATA LEDs) to outputs
	
	LATB	= 0b00000000;
	TRISB	= 0b11111111;		// RB7..0 (DATA buttons) to inputs
	RBPU	= 0;
	WPUB	= 0b11111111;		// with pull-ups

	LATC	= 0b00000000;
	TRISC	= 0b00110001;		// RC5 (LOAD button), RC4 (SAVE button) and RC0 (RUN/STOP button) to inputs, RC3 (RUN/STOP LED) and all unused to outputs
	
	LATD	= 0b00000000;
	TRISD	= 0b00000000;		// RD7..0 (ADDRESS LEDs) to outputs
	
	LATE	= 0b00000000;
	TRISE	= 0b00001111;		// RE3 (NEXT button), RE2 (PREV button), RE1 (SAVE button) and RE0 (GOTO button) to inputs

	// initialize timer 2 (periodic) to 8 MHz (Fosc) / 4 (Fcyc) / 1 (prescale) / 200 (PR2 + 1) / 10 (postscale) = 1000 Hz (1 mS)
	PR2		= 199;
	T2CON	= 0b01001100;		// timer on, 1:1 prescale, 1:10 postscale
	
	lamp_test();
	
	// main loop
	for( ;; )
	{
		t1ms = 0;

		// if timer rolled over, set millisecond event flag for one (and only one) loop iteration
		if( TMR2IF )
		{
			TMR2IF = 0;
			t1ms = 1;
		}
		
		ui_process();
		cpu_process();
	}
}
